#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'goodbye/config' )
   status = context.lookup( 'goodbye/status' )

   runnability = [
         { 'entity' : config, 'qualAttr' : 'globalConfig' },
         { 'entity' : status, 'qualAttr' : 'agentActive' },
         ]

   agentName = "Goodbye"
   agentCfg = {
         'name' : agentName,
         'exe' : "/usr/bin/Goodbye",
         'argv' : [],
         'heartbeatPeriod' : 30,
         'runnability' : runnability
         }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
