#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   systemGpioLedConfig = context.lookup( 'hardware/gpio/config/led' )

   agentName = "GpioLed"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/GpioLed",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "oomScoreAdj" : -400, #  see AID3426
                "runnability" : [ { "entity" : systemGpioLedConfig,
                                   "qualAttr" : "gpioLeds" } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
