#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   cliConfig = context.lookup( 'health/cliConfig' )
   hwConfig = context.lookup( 'health/hwConfig' )
   status = context.lookup( 'health/status' )

   agentName = "HealthMgr"
   runnabilitySupported = { 'entity' : hwConfig,
                           'qualAttr' : 'supported' }
   runnabilityByDefaut = { 'entity' : hwConfig,
                           'qualAttr' : 'enabledByDefault' }
   runnabilityCliExists = { 'entity' : cliConfig,
                            'qualAttr' : 'configExists' } 
   runnabilityNotCliExists = { 'entity' : cliConfig,
                               'qualAttr' : 'configExists',
                               'negate' : True }
   runnabilityEnabled = { 'entity' : cliConfig,
                          'qualAttr' : 'enabled' }
   runnabilityStatusEnabled = { 'entity': status,
                                'qualAttr' : 'enabled' }
   cellFruReady = { 'qualPath': 'hardware/cell/%cellId/FruReady' }
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/HealthMgr',
                'argv' : [],
                'heartbeatPeriod' : 30,
                # runnability = ( ( supported and cellFruReady and
                #                 ( ( !cliExists and enabledByDefault ) or
                #                   ( cliExists and enabled ) )
                #               or statusEnabled )
                'runnability' : [ ( runnabilitySupported, cellFruReady,
                                    [ ( runnabilityNotCliExists,
                                        runnabilityByDefaut ),
                                      ( runnabilityCliExists,
                                        runnabilityEnabled ) ] ),
                                  runnabilityStatusEnabled ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
