# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   hwCapabilities = context.lookup( 'healthMonitor/hwCapabilities' )
   agentName = 'HealthMonitor'
   agentRunnability = [ { 'entity': hwCapabilities,
                          'qualAttr': 'healthMonitorSupported' } ]

   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/HealthMonitor',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': agentRunnability,
              }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
