#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing/multicast/agentstatus' )
   igmpStatus = context.lookup( 'routing/igmp/status' )

   runnability = [ { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'gmpEnabled' },
                   { 'entity' : igmpStatus,
                     'qualAttr' : 'keepRunning' } ]
   agentCfg = { "name": "Igmp",
                "exe": "/usr/bin/Igmp",
                "argv": [ ],
                "heartbeatPeriod": 30,
                "oomScoreAdj": -250, # see AID3426
                "runnability": runnability }

   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( role, agentCfg )

