#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # XXX. we might think of running the agent iff
   # atleast one vlan has snooping enabled, but now it runs unconditionally

   agentName = 'IgmpSnooping'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/IgmpSnooping',
                'argv': [ '--scheduled' ],
                'oomScoreAdj' : -350, #  see AID3426
                'heartbeatPeriod': 30 }
   roleName = { 'rpr' : context.activeSupervisorRoleName,
                'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( roleName, agentCfg )
