# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # InbandTelemetry agent runs if
   # Case 1: Initiator mode
   # 1) Sflow Agent is not running/configured, and
   # 2) Inband Telemetry is running/configured, and
   # 3) Inband Telemetry is supported by hardware, and
   # 4) SampledFlowTracker is not running/configured, and
   # 5) Hardware FlowTracker is not running/configured, and (needs to be removed)
   # 6) PostcardTelemetry is not running
   #   or
   # Case 2: Transit Mode
   # 1) Inband Telemetry is running/configured, and
   # 2) Inband Telemetry is supported by hardware, and
   # 3) isIntTh3Transit case
   # or
   # Case 3: Cleanup did not happen
   # 1) Inband Telemetry agent is already active can happen after a crash

   sflowConfig = context.lookup( "sflow/config" )
   sflowStatus = context.lookup( "sflow/status" )
   intConfig = context.lookup( 'inbandtelemetry/config' )
   intHwCapability = context.lookup( 'inbandtelemetry/hwCapability' )
   sftConfig = context.lookup( 'flowtracking/input/config/sampled/cli' )
   hwFtConfig = context.lookup( 'flowtracking/input/config/hardware/cli' )
   sftLauncherPath = 'flowtracking/activeAgent/sft'
   hwFtLauncherPath = 'flowtracking/activeAgent/hwAccel'
   intLauncherPath = 'flowtracking/activeAgent/inbandTelemetry'
   postcardLauncherPath = 'postcardtelemetry/activeAgent/postcardTelemetry'
   startupGracePeriod = 300
   runnability = [
      (
         [
            (
               { 'entity': sflowConfig, 'qualAttr': 'enabled', 'negate': True },
               { 'entity': sflowStatus, 'qualAttr': 'active', 'negate': True }
            ),
            { 'entity': intHwCapability, 'qualAttr': 'transitOnlyMode' }
         ],
         { 'entity': intConfig, 'qualAttr': 'enable' },
         { 'entity': intHwCapability, 'qualAttr': 'inbandTelemetrySupported' },
         { 'entity' : hwFtConfig, 'qualAttr' : 'enabled', 'negate' : True },
         { 'entity' : sftConfig, 'qualAttr' : 'enabled', 'negate' : True },
         { 'qualPath' : hwFtLauncherPath, 'negate' : True },
         { 'qualPath' : sftLauncherPath, 'negate' : True },
         { 'qualPath': postcardLauncherPath, 'negate': True }
      ),

      { 'qualPath' : intLauncherPath },
   ]

   agentCfg = {
     "name": "InbandTelemetry",
     "exe": "/usr/bin/InbandTelemetry",
     "argv": [],
     "heartbeatPeriod": 90,
     "startupGracePeriod": startupGracePeriod,
     "runnability": runnability
   }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
