#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   status = context.lookup( 'ipsec/capabilities/status' )
   agentName = "Ipsec"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Ipsec",
                "argv" : [],
                "heartbeatPeriod" : 45,
                "startupGracePeriod": 200,
                "runnability": [ { 'entity' : status,
                                   'qualAttr' : 'ipsecSupported' } ]
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
