#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   # -------------------------------------------------------------------------
   # Ira runs unconditionally on "AllSupervisors", whichever cell(s)
   # that actually corresponds to (c.f. AID158). For example, in a
   # fixed-config box, this is the one-and-only cell, while in a
   # modular chassis, it is the cells corresponding to both supervisors.
   #
   # "Running unconditionally" is achieved by specifying no Runnabilities.
   #
   # This might actually belong into a product-specific Launcher plugin,
   # e.g., into a Launcher plugin provided by the Aros package.
   # -------------------------------------------------------------------------

   def configureAgent( agentName, exe ):
      agentCfg = { "name": agentName,
                   "exe": exe,
                   "argv": [],
                   "heartbeatPeriod": 30,
                   "oomScoreAdj": -300, # see AID3426
                   "startupGracePeriod": 300 }
      context.agentConfigIs( roleName, agentCfg )

   roleName = context.allSupervisorsRoleName
   configureAgent( "Ira", "/usr/bin/Ira" )
