#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing/multicast/agentstatus' )
   bessAgentStatusCli = context.lookup( 'bess/agentstatus/cli' )
   bessAgentStatusSfe = context.lookup( 'bess/agentstatus/sfe' )

   runnability = ( { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'multicastEnabled' },
                   { 'entity': bessAgentStatusCli,
                     'qualAttr': 'v4Enabled',
                     'negate': True },
                   { 'entity': bessAgentStatusSfe,
                     'qualAttr' : 'v4Enabled',
                     'negate' : True } )
   agentCfg = { "name": "KernelMfib",
                "exe": "/usr/bin/KernelMfib",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -400, #  see AID3426
                "runnability" : runnability }

   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( role, agentCfg )
