# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Add explicit dependency on Launcher
# pkgdeps: import LauncherContext

def Plugin( context ):
   # L1PolicyAgent runs unconditionally on the active supervisor.
   agentName = "L1PolicyAgent"
   exeName = "/usr/bin/L1PolicyAgent"

   # Use the existence of L1InfraApi on a dut to know that the L1PolicyAgent
   # is runnable. This means the agent will only run on products using the
   # latest and greatest infrastructure.
   # Supporting older products is a potential future effort.
   runnability = { "qualPath": "hardware/l1/policy/l1InfraApi" }

   agentCfg = {
     "name": agentName,
     "exe": exeName,
     "argv": [],
     "heartbeatPeriod": 30,
     "runnability": runnability,
   }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
