#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'l2Rib/config' )

   agentCfg = {    'name' : 'L2Rib',
                   'exe' : '/usr/bin/L2Rib',
                   'argv' : [],
                   'heartbeatPeriod' : 30,
                   "oomScoreAdj": -300, # see AID3426
                   'runnability': [ { 'entity': config,
                                      'qualAttr': 'agentEnabled' } ] }

   roleName = { 'rpr': context.activeSupervisorRoleName,
                'sso': context.allSupervisorsRoleName }
   context.agentConfigIs( roleName, agentCfg )

