#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   ipRouting = context.lookup( "routing/config" )
   mplsRoutingConfig = context.lookup( "routing/mpls/config" )
   ldpEnabledVrfColl = context.lookup( "mpls/ldp/ldpEnabledVrfColl" )
   ldpStatusColl = context.lookup( "mpls/ldp/ldpStatusColl" )
   ldpProtoConfigColl = context.lookup( "mpls/ldp/ldpProtoConfigColl" )
   mldpShared = context.lookup( "mpls/ldp/mldpShared" )
   clientLabelRequest = context.lookup( "mpls/config/labelRequest/ldp" )
   linkReadyStatus = context.lookup( "mpls/ldp/linkReadyStatus" )
   pseudowireLdpStatusPtr = context.lookup( "pseudowire/ldp/status" )
   pseudowireLdpStatus = context.lookup( "pseudowire/ldp/ldpAgentInternalStatus" )
   mldpNexthopConfig = context.lookup( "l3/nexthop-resolver/config/mldp" )
   mldplfibNexthopConfig = context.lookup( "l3/nexthop-resolver/config/mldplfib" )

   agentName = 'LdpAgent'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/LdpAgent',
                'argv': [],
                # LdpAgent is runnable if all (tuple) required configuration is set
                # or any (list) of the agent's write mounts have not been cleaned up.
                'runnability': [
                   (
                      {
                         "entity": ipRouting,
                         "qualAttr": "routing",
                      },
                      {
                         "entity": mplsRoutingConfig,
                         "qualAttr": "mplsRouting",
                      },
                      {
                         "entity": ldpEnabledVrfColl,
                         "qualAttr": "enabledVrf",
                      },
                   ),
                   {
                      "entity": ldpStatusColl,
                      "qualAttr": "status",
                   },
                   {
                      "entity": ldpStatusColl,
                      "qualAttr": "grStatus",
                   },
                   {
                      "entity": ldpProtoConfigColl,
                      "qualAttr": "protoConfig",
                   },
                   {
                      "entity": clientLabelRequest,
                      "qualAttr": "labelRequest",
                   },
                   {
                      "entity": linkReadyStatus,
                      "qualAttr": "readyStatusVrf",
                   },
                   {
                      "entity": pseudowireLdpStatusPtr,
                      "qualAttr": "response",
                   },
                   {
                      "entity": pseudowireLdpStatus,
                      "qualAttr": "response",
                   },
                   {
                      "entity": mldpNexthopConfig,
                      "qualAttr": "vrf",
                   },
                   {
                      "entity": mldplfibNexthopConfig,
                      "qualAttr": "vrf",
                   },
                   {
                      "entity": mldpShared,
                      "qualAttr": "mldpRootIp",
                   },
                ],
                "oomScoreAdj": -300, # see AID3426
                'heartbeatPeriod': 30 }
   # run in all supervisor to support NSF
   roleName = { 'rpr': context.activeSupervisorRoleName,
                'sso': context.allSupervisorsRoleName }
   context.agentConfigIs( roleName, agentCfg )
