#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   features = context.lookup( "sys/license/features" )
   status = context.lookup( "sys/license/client/status" )
   configRequest = context.lookup( "sys/license/client/configRequest" )
   agentCfg = { "name": "LicenseManager",
                "exe": "/usr/bin/LicenseManager",
                "argv": [],
                "runnability": [ { "entity" : features,
                                   "qualAttr": "entityPtr" },
                                 { "entity" : configRequest,
                                    "qualAttr" : "licenseConfigured" },
                                 { "entity" :  status,
                                   "qualAttr" : "active" } ],
                "heartbeatPeriod": 30 }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
