#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   lpConfig = context.lookup( 'loopprotect/config' )
   lpStatus = context.lookup( 'loopprotect/status' )

   agentName = 'LoopProtect'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/' + agentName,
                'argv': [],
                'heartbeatPeriod': 90,
                'runnability': [ { 'entity' : lpConfig,
                                   'qualAttr' : 'globalEnabled' },
                                 { 'entity' : lpStatus,
                                   'qualAttr' : 'running' } ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )


