#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Swag import swagMode

def Plugin( context ):

   if not swagMode():
      return

   agentCfg = {
      'name': 'MemberIdentifier',
      'exe': '/usr/bin/MemberIdentifier',
      'argv': [ '--smid=%(smid)s' ],
      'heartbeatPeriod': 30,
      'swagRunnabilityFilter': context.allSwagMembers
   }
   context.agentConfigIs( context.activeSupervisorRoleName, agentCfg )
