#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.


# Because of its 'runnability' setting, this agent is added to
# conditionalStartAgentsToIgnoreLauncherMsg in ArosTestPlugin to prevent spurious
# ptest failures due to unrecognized logs triggered by config change/tampering

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = "Mirroring"
   mirroringCliConfig = context.lookup( 'mirroring/config' )
   mirroringHwConfig = context.lookup( 'mirroring/hwconfig' )
   tapaggCliConfig = context.lookup( 'tapagg/cliconfig' )
   tapaggHwConfig = context.lookup( 'tapagg/hwconfig' )
   tapaggModeIntfs = context.lookup( 'tapagg/tapAggModeIntfs' )
   errDisableTapaggCause = context.lookup( 'interface/errdisable/cause/tapagg' )
   runnability = [ { 'entity': mirroringCliConfig, 'qualAttr': 'session' },
                   { 'entity': mirroringHwConfig, 'qualAttr': 'session' },
                   { 'entity': tapaggCliConfig, 'qualAttr': 'mirroringRunnability' },
                   { 'entity': tapaggHwConfig, 'qualAttr': 'mirroringRunnability' },
                   { 'entity': tapaggHwConfig, 'qualAttr': 'tapPort' },
                   { 'entity': tapaggHwConfig, 'qualAttr': 'toolPort' },
                   { 'entity': tapaggModeIntfs, 'qualAttr': 'entry' },
                   { 'entity': errDisableTapaggCause, 'qualAttr': 'intfStatus' }
                 ]
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Mirroring",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": runnability }

   # active supervisor only for now
   roleName = context.activeSupervisorRoleName

   context.agentConfigIs( roleName, agentCfg )
