#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
# pkgdeps: import LauncherContext
import Toggles.MlagToggleLib

def Plugin( context ):
   if Toggles.MlagToggleLib.toggleMlagL2SubinterfacesEnabled():
      mlagConfig = context.lookup( "mlag/input/config/cli" )
   else:
      mlagConfig = context.lookup( "mlag/config" )
   proto = context.lookup( "mlag/proto" )

   runnability = [ ( { 'entity' : mlagConfig, 'qualAttr' : 'enabled' },
                     { 'entity' : mlagConfig, 'qualAttr' : 'domainId' },
                     { 'entity' : mlagConfig, 'qualAttr' : 'localIntfId' },
                     { 'entity' : mlagConfig, 'qualAttr' : 'peerAddressConfigured' },
                     { 'entity' : mlagConfig, 'qualAttr' : 'peerLinkIntfId' } ),
                   { 'entity' : proto, 'qualAttr' : 'running' } ]
   for agentName in ( "Mlag", "MlagTunnel" ):
      agentCfg = { "name" : agentName,
                   "exe" : "/usr/bin/" + agentName,
                   "argv" : [],
                   "heartbeatPeriod" : 30,
                   "runnability" : runnability }

      roleName = { 'rpr' : context.activeSupervisorRoleName,
                   'sso' : context.allSupervisorsRoleName }
      context.agentConfigIs( roleName, agentCfg )
