#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   msdpConfigColl = context.lookup( 'routing/msdp/config' )
   runnability = [ { 'entity' : msdpConfigColl,
                     'qualAttr' : 'vrfConfig' } ]

   agentCfg = { "name": "Msdp",
                "exe": "/usr/bin/Msdp",
                "argv": [ "--scheduled" ],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -50, #  see AID3426
                "runnability" : runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
