#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mssClientStatus = context.lookup( "mssclient/status" )

   mgmtControllerStatus = context.lookup( "mgmt/controller/status" )

   runnability = [ { "entity" : mgmtControllerStatus, "qualAttr" : "enabled" },
                   { "entity" : mssClientStatus, "qualAttr" : "active" } ]
   agentCfg = { "name" : "MssClient",
                "exe" : "/usr/bin/MssClient",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability" : runnability
         }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
