#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'ip/nat/config' )
   status = context.lookup( 'ip/nat/status' )

   agentName = 'Nat'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/Nat',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability': [ { 'entity' : config,
                                   'qualAttr' : 'intfConfig' },
                                 { 'entity' : config,
                                   'qualAttr' : 'vrfConfig' },
                                 { 'entity' : config,
                                   'qualAttr' : 'natFlow' },
                                 { 'entity' : status,
                                   'qualAttr' : 'intfStatus' } ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

