# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This is used to generate dependency on Launcher
# pkgdeps: import LauncherContext

# A note on the qualPath for runnability:
# For the runnability, we cannot use a cell specific qualAttr (like isOliveHw). If we
# do that, we end up in a breadth test failure in the following tests:
# - Sequoia/test/SequoiaWimpySwitchoverTest.py
# - Yosemite/test/YosemiteWimpySwitchoverTest.py
# Both tests will fail saying timedout waiting for orphans to go away. And they will
# specifically complain about the isOliveHw path.
# It turns out the Fru does not clean up cell specific qualAttr correctly on switch
# over and they end up as orphans. The solution is to use a *qualPath*, which is why
# we have that launcheConfig path which is only used for the runnability. That is
# set by the Fru plugins on Olive hw.
def Plugin( context ):
   agentName = "Olive"
   runnability = [ { "qualPath": "cell/%cellId/hardware/olive/launcherConfig/%*" } ]
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Olive",
                "argv": [],
                "heartbeatPeriod" : 30,
                "runnability" : runnability }
   # Though Olive doesn't start in standby, instead starts during switchover stages
   # after Fru-Plugins stage, need to start in `allSupervisors` mode to be able to
   # participate in switchover stages. Olive agent need to delay Macsec platform
   # agents start until all its tpmInitialization is completed
   roleName = { 'rpr': context.activeSupervisorRoleName,
                'sso': context.allSupervisorsRoleName }

   context.agentConfigIs( roleName, agentCfg )
