#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
# pkgdeps: import LauncherContext
from OpenConfigLauncherLib import enabled, launchRequest, openConfigRunnability
from Toggles.OpenConfigLibToggleLib import toggleOCOnStandbyEnabled

def getOpenConfigRunnability( context ):
   # OpenConfig is runnable if we have any common config, and Octa has not been
   # configured (explicitly or via launch request)
   octaEntity = context.lookup( "mgmt/octa/config" )
   openConfigLaunchRequestEntity = context.lookup( "mgmt/gnmi/launchRequest" )

   # Tuple means AND, AID5312 has more info on runnability formatting
   return ( openConfigRunnability( context ),
         enabled( octaEntity, True ),
         launchRequest( openConfigLaunchRequestEntity, True )
      )

def getOctaRunnability( context ):
   # Octa is runnable if we have any common config AND it is enabled or there
   # is a launch request
   octaEntity = context.lookup( "mgmt/octa/config" )
   openConfigLaunchRequestEntity = context.lookup( "mgmt/gnmi/launchRequest" )

   # List means OR, AID5312 has more info on runnability formatting
   # ( Common AND enabled ) OR LaunchRequest
   return [
      ( openConfigRunnability( context ),
        enabled( octaEntity ) ),
      launchRequest( openConfigLaunchRequestEntity ) ]

def Plugin( context ):
   # Allow namespace launcher dut to pass arguments to OpenConfig/Octa
   argVStr = os.getenv( "OC_OCTA_LAUNCHER_ARGS" )
   launcherArgs = argVStr.split() if argVStr else []

   agentCfg = { "name": "OpenConfig",
                "exe": "/usr/bin/OpenConfig",
                "argv": launcherArgs,
                "runnability": getOpenConfigRunnability( context ),
                "heartbeatPeriod": 30,
                "startupGracePeriod": 900, # give time for dumptypes
              }

   octaCfg = { "name": "Octa",
               "exe": "/usr/bin/Octa",
               "argv": launcherArgs,
               "runnability": getOctaRunnability( context ),
               "heartbeatPeriod": 30,
               "startupGracePeriod": 900, # give time for dumptypes
             }

   roleName = context.activeSupervisorRoleName
   if toggleOCOnStandbyEnabled():
      roleName = { 'rpr': context.activeSupervisorRoleName,
                   'sso': context.allSupervisorsRoleName }

   context.agentConfigIs( roleName, agentCfg )
   context.agentConfigIs( roleName, octaCfg )
