#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps : import LauncherContext

from __future__ import absolute_import, division, print_function
from LauncherPlugin.Rib import registerAgent

def Plugin( context ):
   # Ospf should run only when the device is in multi-agent mode
   runnability = ( { "qualPath" :
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Ospf" }, )

   # Register Main Ospf ( BR )
   registerAgent( context, "Ospf", runnability, [] )

   # Vrf Ospf ( VR ) is always conditional on the existence of vrf status
   vrfRunnability = \
       ( { "qualPath" : "cell/%cellId/routing/OspfVrfLaunchIndicator/%sliceId" }, )
   argv = ( "--z", "'client vrfname %(sliceId)s ns-name ns-%(sliceId)s'",
            "--sliceId=%(sliceId)s" )
   registerAgent( context, "Ospf-vrf", vrfRunnability, argv,
                 exeName="/usr/bin/Ospf-vrf" )
