#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps : import LauncherContext

from __future__ import absolute_import, division, print_function
from LauncherPlugin.Rib import registerAgent

def Plugin( context ):
   # Ospf3 should run only when the device is in multi-agent mode
   runnability = ( { "qualPath" :
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Ospf3" }, )

   # Register Main Ospf3 ( BR )
   registerAgent( context, "Ospf3", runnability, [] )

   # Vrf Ospf3 ( VR ) is always conditional on the existence of vrf status
   vrfRunnability = \
       ( { "qualPath" : "cell/%cellId/routing/Ospf3VrfLaunchIndicator/%sliceId" }, )
   argv = ( "--z", "'client vrfname %(sliceId)s ns-name ns-%(sliceId)s'",
            "--sliceId=%(sliceId)s" )
   registerAgent( context, "Ospf3-vrf", vrfRunnability, argv,
                 exeName="/usr/bin/Ospf3-vrf" )
