#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = 'P4Runtime'
   p4RtSystemConfig = context.lookup( 'p4runtime/config/system' )
   p4RtSystemStatus = context.lookup( 'p4runtime/status/system' )
   # P4Runtime agent is started when it is enabled via "no shutdown" via CLI in
   # in p4-runtime mode (and hence sets p4RtSystemConfig.enabled to True).
   # However, when it is disabled, we want the things created by P4 Runtime
   # operations to be cleaned-up before it is killed by Launcher. Therefore, in
   # that case, p4RtSystemConfig.enabled is set to False by the CLI, and the
   # P4Runtime agent reacts to it, cleans-up the states, and then sets
   # p4RtSystemStatus.enabled to False..
   # Hence, the runnability condition below, which allows the launcher to start the
   # agent if p4RtSystemConfig.enabled or p4RtSystemStatus.enabled, and the agent is
   # stopped if neither of it is set.
   p4RuntimeAgentCfg = { 'name' : agentName,
                         'launchName' : 'P4Runtime',
                         'exe' : '/usr/bin/P4Runtime',
                         'argv' : [],
                         'oomScoreAdj' : -100, # See AID3426
                         'heartbeatPeriod' : 180,
                         'runnability' : [ ( { 'entity' : p4RtSystemConfig,
                                               'qualAttr' : "enabled" } ),
                                           ( { 'entity' : p4RtSystemStatus,
                                               'qualAttr' : "enabled" } ),
                                           ]
   }

   # No sso yet
   roleName = context.activeSupervisorRoleName

   context.agentConfigIs( roleName, p4RuntimeAgentCfg )

