# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   libConfig = context.lookup( 'hardware/pluto/library/config' )
   daemonDir = context.lookup( 'hardware/pluto/daemons' )
   xcvrPLDevice = context.lookup( 'hardware/platform/xcvr/device' )

   agentName = 'PLXcvr'
   agentCfg = {
         'name' : agentName,
         'exe' : '/usr/bin/PLXcvr',
         'argv' : [],
         'heartbeatPeriod' : 30,
         'runnability' : (
            { 'entity' : xcvrPLDevice, 'qualAttr' : 'xcvrConfig' },
            { 'entity' : libConfig, 'qualAttr' : 'libPath' },
            { 'entity' : daemonDir, 'qualAttr' : 'warm' },
         )
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

