#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell

# pkgdeps: import LauncherContext

def Plugin( context ):
   if Cell.cellType() == 'supervisor':
      runnability = [ { 'qualPath': "picasso/control/cell/%cellId.enabled/%*" } ]

      agentCfg = { "name": "Picasso",
                   "exe": "/usr/bin/Picasso",
                   "argv": [],
                   "heartbeatPeriod": 30,
                   "runnability" : runnability  }

      roleName = { 'rpr' : context.activeSupervisorRoleName,
                   'sso' : context.allSupervisorsRoleName }
      context.agentConfigIs( roleName, agentCfg )
