#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing/multicast/agentstatus' )

   runnability = [ { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'pimEnabled' }, ]
   agentCfg = { "name": "Pim",
                "exe": "/usr/bin/Pim",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -400, #  see AID3426
                "runnability" : runnability }

   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }

   context.agentConfigIs( role, agentCfg )
