#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing6/multicast/agentstatus' )
   runnability = [ { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'pimbsrEnabled' } ]

   # PimBsr runs unconditionally on the active supervisor.
   agentCfg = { "name": "PimBsr6",
                "exe": "/usr/bin/PimBsr6",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -50, #  see AID3426
                "runnability" : runnability }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
