#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This generates a dependency on Launcher
# pkgdeps: import LauncherContext

def Plugin( context ):

   # The PowerSupplyExternal agent should only be applicable to fixed systems,
   # so the active supervisor role is suitable.
   agentName = 'PowerSupplyExternal'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/PowerSupplyExternal',
                'argv' : [],
                'heartbeatPeriod' : 30,
                "runnability" : [
                   { "qualPath" : "hardware/powerSupply/external/launcherConfig/%*" }
                ]
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
