#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   config = context.lookup( 'hardware/powerSupply/fixed/config' )

   # Configure the PowerSupplyFixed agent to always run on the ActiveSupervisor
   # whenever a fixed power supply exists in the fixed dir

   agentName = 'PowerSupplyFixed'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/PowerSupplyFixed',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability' : [ { 'entity' : config,
                                    'qualAttr' : 'fixedConfig' } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

