# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import PseudowireAgent

# pkgdeps: import LauncherContext

def Plugin( context ):
   # Gate pseudowire agent when there is no patch config (implying that
   # pseudowires are not being used; before shutdown, make sure that output
   # states that need to be cleaned up are cleaned up.
   config = context.lookup( "pseudowire/runnability/config" )
   status = context.lookup( "pseudowire/runnability/agent" )

   vplsConfig = context.lookup( "vpls/config" )

   runnability = [
      # Gating with patch configuration
      { "entity": config,
        "qualAttr": "config",
      },
      # Gating with mpls label request from pseudowire.
      { "entity": status,
        "qualAttr": "labelRequest",
      },
      # Gating with VLAN id/VLAN tag/Interface type request to Ebra.
      { "entity": status,
        "qualAttr": "ebraRequest",
      },
      # Gating with program request to Ebra.
      { "entity": status,
        "qualAttr": "ebraProgramRequest",
      },
      # Gating with LDP request.
      { "entity": status,
        "qualAttr": "ldpRequest",
      },
      # Gating with BGP request.
      { "entity": status,
        "qualAttr": "bgpRequest",
      },
      # Gating with LFIB routes.
      { "entity": status,
        "qualAttr": "lfib",
      },
      # Gating with pseudowire status objects for Ale/platform.
      { "entity": status,
        "qualAttr": "status",
      },
      # Gating with VplsVeConfig config for BGP agent
      { "entity": status,
        "qualAttr": "vplsVeConfigRequest",
      },
      # Gating with VPLS-BGP pseudowires for Ale/Platform
      { "entity": status,
        "qualAttr": "vplsVeBgpPseudowire",
      },
      # VPLS instance configuration
      { "entity": vplsConfig,
        "qualAttr": "instance",
      },
   ]

   agentCfg = {
      "name": PseudowireAgent.name,
      "exe": "/usr/bin/Pseudowire",
      "argv": [],
      "heartbeatPeriod": 30,
      "runnability" : runnability,
   }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
