# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   rcfConfig = context.lookup( "routing/rcf/config" )
   rcfStatus = "cell/%cellId/routing/rcf/status.enabled/enabled"

   agentCfg = { "name": "Rcf",
                "exe": "/usr/bin/Rcf",
                "argv": [],
                "heartbeatPeriod": 30,
                "startupGracePeriod": 150,
                # Tiny bit lower than agents that depends on us (Bgp is -300)
                "oomScoreAdj": -350,
                "runnability": [ { "entity": rcfConfig,
                                   "qualAttr": "enabled" },
                                 { "qualPath": rcfStatus }, ]
              }
   roleName = context.allSupervisorsRoleName
   context.agentConfigIs( roleName, agentCfg )

