#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = 'RouteCache'
   routeCacheConfig = context.lookup( 'routecache/config' )
   routingHwStatus = context.lookup( 'routing/hardware/status' )
   runnability = [
      # runnability is:
      # ( routeCache supported OR
      #   staticVxlanRouteRibBypass supported OR
      #   routecache/config/cleanupRequired TRUE )
      { 'entity': routingHwStatus, 'qualAttr': 'routeCacheSupported' },
      { 'entity': routingHwStatus,
        'qualAttr': 'staticVxlanRouteRibBypassSupported' },
      { 'entity': routeCacheConfig, 'qualAttr': 'cleanupRequired' }
   ]
   agentCfg = { 'name': agentName,
                     'launchName': agentName,
                     'exe': '/usr/bin/RouteCache',
                     'argv': [],
                     'heartbeatPeriod': 180,
                     'runnability': runnability }

   roleName = context.activeSupervisorRoleName

   context.agentConfigIs( roleName, agentCfg )
