#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Add explicit dependency on Launcher
# pkgdeps: import LauncherContext
import Tac

def Plugin( context ):
   agentName = 'RsvpProtocol'
   cliConfig = context.lookup( Tac.Type( "Rsvp::RsvpCliConfig" ).mountPath )
   status = context.lookup( Tac.Type( "Rsvp::RsvpSysdbStatus" ).mountPath )

   rsvpConfigured = { 'entity': cliConfig,
                      'qualAttr': 'enabled' }

   rsvpRunning = { 'entity': status,
                   'qualAttr': 'rsvpProtocolAgentRunnable',
                 }

   aleSyncStatus = { 'qualPath': 'cell/%cellId/ale/sync/ipRouteSyncDone', }

   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/RsvpProtocol',
                'argv': [],
                # Run if either RsvpProtocol is configured or still wants to
                # run, but in either case only when ale/PD has finished the
                # sync process after SSO.
                'runnability': ( [ rsvpConfigured, rsvpRunning ],
                                 aleSyncStatus ),
                "oomScoreAdj": -300, # see AID3426
                'heartbeatPeriod': 30 }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
