# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( "serverProbe/config.protocolConfig/radius" )
   status = context.lookup( "serverProbe/allServerStatus" )
   counterStatus = context.lookup(
         "serverProbe/counter/status.protocolCounters/radius" )
   agentName = 'ServerProbe'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/ServerProbe',
                'argv': [],
                'runnability': [ { "entity": config,
                                   "qualAttr": "serviceList", },
                                 { "entity": status,
                                   "qualAttr": "status", },
                                 { "entity": status,
                                   "qualAttr": "servicesEnabled", },
                                 { "entity": counterStatus,
                                   "qualAttr": "hostCounters", },
                                 ],
                'heartbeatPeriod': 30 }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
