#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
# pkgdeps: import Toggles.PostcardTelemetryCommonToggleLib

def Plugin( context ):
   agentName = "Sflow"

   # Sflow agent is started if
   # Sflow is configured and
   #    Sampled-flow-tracking agent (SftAgent) is not running and
   #    INT is on th3 chip(transitOnlyMode)  "or"  INT agent is not running, and
   #    PostcardTelemetry agent is not running when postcard interop is not supported
   # or
   # Sflow is already active (SflowStatus.active is set)

   # If Sft or INT or PostcardTelemetry (PostcardTelemetry when postcard interop is
   # not supported) agent is running, Sflow agent waits for
   # that agent to shutdown. When Sflow is enabled via CLI, Sft/INT/PT agent
   # shutdown is initiated and when agent shutdown is complete (indicated
   # by deleting activeAgent entry), Launcher will start Sflow agent.
   # except when chip is Th3 then as INT only supports transit mode and hence INT can
   # work even when sFlow is enabled, so in that case we allow INT agent to run
   # alongside sFlow agent
  
   sflowConfig = context.lookup( "sflow/config" )
   sflowStatus = context.lookup( "sflow/status" )
   intLauncherPath = 'flowtracking/activeAgent/inbandTelemetry'
   sftLauncherPath = 'flowtracking/activeAgent/sft'
   dropExportConfig = context.lookup( "sflow/dropExportConfig" )
   intHwCapability = context.lookup( 'inbandtelemetry/hwCapability' )
   postcardHwCapability = context.lookup( 'postcardtelemetry/hwCapability' )
   postcardLauncherPath = 'postcardtelemetry/activeAgent/postcardTelemetry'

   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Sflow",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj": -100, # see AID3426
                "runnability":
                [ (
                    [
                      { "entity": intHwCapability,
                        "qualAttr": "transitOnlyMode" },
                      { "qualPath": intLauncherPath,
                        "negate": True } ],
                    [
                      { 'entity': postcardHwCapability,
                        'qualAttr': 'postcardTelemetrySflowInteropSupported', },
                      { "qualPath": postcardLauncherPath,
                        "negate": True }, ],
                    { "qualPath": sftLauncherPath,
                      "negate": True },
                    [
                      { "entity": sflowConfig,
                        "qualAttr": "enabled" },
                      { "entity": dropExportConfig,
                        "qualAttr": "enabled" }, ]
                  ),
                  { "entity": sflowStatus,
                    "qualAttr": "active" }
                ]
              }

   roleName = context.allSupervisorsRoleName
   context.agentConfigIs( roleName, agentCfg )
