#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'snmp/config' )

   agentCfg = { 'name' : 'Snmp',
                'exe' : '/usr/bin/Snmp',
                'argv' : [],
                'heartbeatPeriod' : 60,
                # Nudge the OOM killer toward smaller non-essential processes.
                # We should be using OOM_NONESSENTIAL_PROC but it is much too high,
                # so hardcoding 200 for now. When BUG756677 is fixed this should
                # change back to use ProcMgrLib.OOM_NONESSENTIAL_PROC
                'oomScoreAdj': 200, # see AID3426
                'startupGracePeriod' : 600,     # see BUG48278
                'runnability': [ { 'entity' : config,
                                   'qualAttr' : 'serviceEnabled' } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
