#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = 'Srv6'
   configEnt = context.lookup( 'routing/srv6/config' )
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/Srv6',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': [ { 'entity': configEnt,
                                   'qualAttr': 'created' } ]
               }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
