# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

from __future__ import absolute_import, division, print_function
def Plugin( context ):
   agentCfg = {
      "name": "StorageDevices",
      "exe": "/usr/bin/StorageDevices",
      "argv": [],
      "heartbeatPeriod" : 30,
      # We can't use the entmib entity because Launcher will complain that
      # 'EntityMib::Status' has no attribute 'entityPtr'. So we have to do
      # runnability this way
      "runnability" : [ {
         "qualPath": "hardware/cell/%cellId/storageDevices/launcherConfig/%*",
      } ],
   }

   roleName = context.allSupervisorsRoleName

   context.agentConfigIs( roleName, agentCfg )
