# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import to add dependency on Launcher
# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( "stun/client/cliConfig" )
   serverProfileConfig = context.lookup( "stun/server-profile" )
   stunClientStatus = context.lookup( "stun/client/status" )

   disabled = [
      { 'entity': config,
        'qualAttr' : 'disabled',
        'negate' : True,
       },
   ]
   serverProfileConfigured = [
      { 'entity': serverProfileConfig,
        'qualAttr' : 'serverProfile',
       },
   ]
   active = {
      'entity' : stunClientStatus,
      'qualAttr' : 'active',
   }

   # runnability is a combination of ( disabled && serverProfileConfigured ) ||
   # active
   runnability = [ ( disabled, serverProfileConfigured ), active ]

   agentCfg = {
      "name" : "StunClient",
      "exe" : "/usr/bin/StunClient",
      "argv" : [],
      "heartbeatPeriod" : 300,
      "runnability" : runnability,
   }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
