# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Swag
from LauncherContext import LauncherContext
from typing import Type

def Plugin( context: Type[ LauncherContext ] ) -> None:
   if not Swag.isMember():
      return
   if not Swag.isSupervisor():
      return

   agentCfg = { "name": "SupervisorSchanAccelProxy",
                "exe": "/usr/bin/SupervisorSchanAccelProxy",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj": -300,
                "runnability": [],
   }

   context.agentConfigIs( context.allSupervisorsRoleName, agentCfg )
