#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint cannot distinquish between SwagCore/Swag.py and
# SwagAgent/LauncherPlugin/Swag.py
from Swag import role, swagMode # pylint: disable=import-self

def Plugin( context ):
   # The Swag agent never runs unless EOS is in SWAG mode. In the SWAG 'candidate'
   # role (i.e. incarnation 2), the Swag agent is conditional on the 'switch
   # aggregation; member id ID' configuration. When acting as a SWAG 'supervisor',
   # the Swag agent runs unconditionally. Finally, the Swag agent never runs on a
   # SWAG 'worker'.
   if not swagMode():
      return
   if role() == 'worker':
      return

   runnability = None
   if role() in ( 'supervisorSwitch', 'supervisorServer' ):
      runnability = []
   elif role() == 'candidate':
      config = context.lookup( 'swag/config' )
      runnability = {
            # swag member ID configured
            'entity': config,
            'qualAttr': 'memberId',
      }

   assert runnability is not None, f'Unexpected SWAG role={role()}'
   agentCfg = {
      'name': 'Swag',
      'exe': '/usr/bin/Swag',
      'argv': [],
      'heartbeatPeriod': 30,
      'runnability': runnability,
   }
   context.agentConfigIs( context.allSupervisorsRoleName, agentCfg )
