# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

import Tac
import Swag

SwagFilter = Tac.Type( 'Launcher::SwagRunnabilityFilter' )

def Plugin( context ):
   runnability = None

   if not Swag.swagMode():
      return

   agentCfg = { "name": "SwagAsicFifoProxy",
                "exe": "/usr/bin/SwagAsicFifoProxy",
                "argv": [ '--smid=%(smid)s' ],
                "heartbeatPeriod": 30,
                "oomScoreAdj": -300, # see AID3426
                "runnability": runnability,
                "swagRunnabilityFilter": { SwagFilter.worker,
                                           SwagFilter.supervisorSwitch },
   }

   context.agentConfigIs( context.allSupervisorsRoleName, agentCfg )
