#!/usr/bin/env arista-python
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import (
   absolute_import,
   division,
   print_function,
)

def Plugin( context ):
   instanceConfig = context.lookup( "synce/config/instance" )
   runnabilityStatus = context.lookup( "synce/runnability/status" )
   # Note: Launcher runnability cannot use HwCapability::synceSupported as
   # it's non-notifying. Launcher will instead react/depend on
   # HwCapability::option(1|2)LocalQualityLevel
   hwCapability = context.lookup( "synce/hw/capability" )
   runnability = [
      # hwCapability::synceSupported (option(1|2) QL's set AND cliConfig::enable
      (
         {
            "entity": hwCapability,
            "qualAttr": "option1LocalQualityLevel"
         },
         {
            "entity": hwCapability,
            "qualAttr": "option2LocalQualityLevel"
         },
         {
            "entity": instanceConfig,
            "qualAttr": "enable"
         },
      ),
      # OR any of the dirty sysdb states
      {
         "entity": runnabilityStatus,
         "qualAttr": "eecDirty"
      },
      {
         "entity": runnabilityStatus,
         "qualAttr": "esmcDirty"
      },
      {
         "entity": runnabilityStatus,
         "qualAttr": "selectionDirty"
      },
   ]
   agentCfg = {
      "name": "Synce",
      "exe": "/usr/bin/Synce",
      "argv": [],
      "heartbeatPeriod": 30,
      "runnability": runnability,
   }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
