#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherContext

def Plugin( context ):
   configPath = "tepicmphelper/input/config/vxlan"
   statusPath = "tepicmphelper/input/status/vxlan"

   # Configure the TepIcmpHelper agent to run on the active supervisor when
   # requested via config
   agentName = "TepIcmpHelper"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/TepIcmpHelper",
                "argv": [],
                "heartbeatPeriod": 120,
                "oomScoreAdj": -350, # see AID3426
                "runnability": [ { "qualPath": configPath },
                                 { "qualPath": statusPath } ]
               }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
