#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # Look up the hardware fan slot config/status
   fanConfig = context.lookup( 'hardware/fan/config' )
   fanStatus = context.lookup( 'hardware/fan/status' )

   # Configure the Thermostat agent to always run on the ActiveSupervisor
   agentName = 'Thermostat'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/Thermostat',
                'argv' : [],
                'oomScoreAdj' : -100, #  see AID3426
                'heartbeatPeriod' : 30 }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

   # Configure the FanDetector agent to run on the ActiveSupervisor when fan
   # slots are defined
   agentName = 'FanDetector'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/FanDetector',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability' : [ { 'entity' : fanConfig,
                                    'qualAttr' : 'slotConfig' },
                                  { 'entity' : fanStatus,
                                    'qualAttr' : 'slotStatus' }  ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

