#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import TunnelAgent

# pkgdeps: import LauncherContext

def Plugin( context ):
   def configureAgent( agentName, exe ):
      agentCfg = { "name": agentName,
                   "exe": exe,
                   "argv": [],
                   "oomScoreAdj" : -300, #  see AID3426
                   "heartbeatPeriod": 30 }

      context.agentConfigIs( roleName, agentCfg )

   # run in all supervisor to support NSF in SSO (aid/6343)
   roleName = { 'rpr': context.activeSupervisorRoleName,
                'sso': context.allSupervisorsRoleName }

   configureAgent( TunnelAgent.name, "/usr/bin/Tunnel" )

