#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   tunnelIntfConfigDir = context.lookup( 'interface/config/tunnel/intf' )
   tunnelIntfStatusDir = context.lookup( 'interface/status/tunnel/intf' )
   routingHwStatus = context.lookup( 'routing/hardware/status' )

   tunIntfConfig = { 'entity' : tunnelIntfConfigDir,
                     'qualAttr' : 'intfConfig',
                     'readableText' : 'Static tunnel interface configured' }
   tunIntfStatus = { 'entity' : tunnelIntfStatusDir,
                     'qualAttr' : 'intfStatus',
                     'readableText' : 'Static tunnel interface status present' }
   runnabilitySupported = { 'entity' : routingHwStatus,
                            'qualAttr' : 'staticTunIntfPlatformCapabilityDeclared',
                            'readableText' : 'Platform capability declared' }
   # runnability = ( runnabilitySupported and ( tunIntfConfig or
   #                 tunIntfStatus ) )
   agentCfg = { 'name': 'TunnelIntf',
                'exe': '/usr/bin/TunnelIntf',
                'argv': [],
                'heartbeatPeriod': 30,
                "oomScoreAdj" : -300, #  see AID3426
                'runnability': [ ( runnabilitySupported,
                               [ tunIntfConfig, tunIntfStatus ] ) ]
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
